#include <iostream>
#include <CPPToPigpio.h>

using namespace std;
float starting_f = 8000.0f;
CPPToPigpio::BusIn switchBus(p25, p24, p23, p18);
float divisions[] = {1.0f, 2.0f, 4.0f, 5.0f, 8.0f, 10.0f, 16.0f,
    20.0f, 25.0f, 32.0f, 40.0f, 50.0f, 80.0f, 100.0f, 160.0f, 200.0f};
CPPToPigpio::PwmOut outThing(p21);

int main(){
    switchBus.mode(PullDown);
    outThing.period(1.0f/starting_f);
    outThing = 0.5f;
    while(1) {
        int total = switchBus;
        outThing.period(divisions[total]/starting_f);
        cout << "frequency should be " << starting_f/divisions[total];
        time_sleep(1);
    }
}
